/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.NumberExpressionBase;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class IntegerExpression
extends NumberExpressionBase
implements ObservableIntegerValue {
    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public Integer getValue() {
        return this.get();
    }

    public static IntegerExpression integerExpression(final ObservableIntegerValue value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof IntegerExpression ? (IntegerExpression)value : new IntegerBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected int computeValue() {
                return value.get();
            }

            @Override
            public ObservableList<ObservableIntegerValue> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public static <T extends Number> IntegerExpression integerExpression(final ObservableValue<T> value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof IntegerExpression ? (IntegerExpression)value : new IntegerBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected int computeValue() {
                Number val = (Number)value.getValue();
                return val == null ? 0 : val.intValue();
            }

            @Override
            public ObservableList<ObservableValue<T>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    @Override
    public IntegerBinding negate() {
        return (IntegerBinding)Bindings.negate(this);
    }

    @Override
    public DoubleBinding add(double other) {
        return Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding add(float other) {
        return (FloatBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding add(long other) {
        return (LongBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public IntegerBinding add(int other) {
        return (IntegerBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(double other) {
        return Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding subtract(float other) {
        return (FloatBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding subtract(long other) {
        return (LongBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public IntegerBinding subtract(int other) {
        return (IntegerBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(double other) {
        return Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding multiply(float other) {
        return (FloatBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding multiply(long other) {
        return (LongBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public IntegerBinding multiply(int other) {
        return (IntegerBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(double other) {
        return Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding divide(float other) {
        return (FloatBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding divide(long other) {
        return (LongBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public IntegerBinding divide(int other) {
        return (IntegerBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    public ObjectExpression<Integer> asObject() {
        return new ObjectBinding<Integer>(){
            {
                this.bind(IntegerExpression.this);
            }

            @Override
            public void dispose() {
                this.unbind(IntegerExpression.this);
            }

            @Override
            protected Integer computeValue() {
                return IntegerExpression.this.getValue();
            }
        };
    }
}

